/* eslint-disable max-lines, @typescript-eslint/naming-convention */
// Auto-generated by Supabase — do not edit manually.
export type Json = string | number | boolean | null | { [key: string]: Json | undefined } | Json[];

export type Database = {
  // Allows to automatically instantiate createClient with right options
  // instead of createClient<Database, { PostgrestVersion: 'XX' }>(URL, KEY)
  __InternalSupabase: {
    PostgrestVersion: '14.1';
  };
  public: {
    Tables: {
      check_ins: {
        Row: {
          created_at: string | null;
          date: string;
          energy_level: string;
          goal_id: string;
          id: string;
          note: string | null;
          user_id: string;
        };
        Insert: {
          created_at?: string | null;
          date: string;
          energy_level: string;
          goal_id: string;
          id?: string;
          note?: string | null;
          user_id: string;
        };
        Update: {
          created_at?: string | null;
          date?: string;
          energy_level?: string;
          goal_id?: string;
          id?: string;
          note?: string | null;
          user_id?: string;
        };
        Relationships: [
          {
            foreignKeyName: 'check_ins_goal_id_fkey';
            columns: ['goal_id'];
            isOneToOne: false;
            referencedRelation: 'goals';
            referencedColumns: ['id'];
          },
        ];
      };
      coaches: {
        Row: {
          created_at: string;
          deepgram_voice_id: string;
          deepgram_voice_model: string;
          description_en: string;
          description_fr: string;
          display_name_en: string;
          display_name_fr: string;
          icon: string;
          id: number;
          is_active: boolean;
          personality: string;
        };
        Insert: {
          created_at?: string;
          deepgram_voice_id: string;
          deepgram_voice_model?: string;
          description_en: string;
          description_fr: string;
          display_name_en: string;
          display_name_fr: string;
          icon: string;
          id?: number;
          is_active?: boolean;
          personality: string;
        };
        Update: {
          created_at?: string;
          deepgram_voice_id?: string;
          deepgram_voice_model?: string;
          description_en?: string;
          description_fr?: string;
          display_name_en?: string;
          display_name_fr?: string;
          icon?: string;
          id?: number;
          is_active?: boolean;
          personality?: string;
        };
        Relationships: [];
      };
      context_embeddings: {
        Row: {
          batch_id: string | null;
          content_text: string;
          content_type: string;
          created_at: string;
          embedding: string;
          goal_id: string;
          id: string;
          metadata: Json | null;
          profile_id: string | null;
          user_id: string;
        };
        Insert: {
          batch_id?: string | null;
          content_text: string;
          content_type?: string;
          created_at?: string;
          embedding: string;
          goal_id: string;
          id?: string;
          metadata?: Json | null;
          profile_id?: string | null;
          user_id: string;
        };
        Update: {
          batch_id?: string | null;
          content_text?: string;
          content_type?: string;
          created_at?: string;
          embedding?: string;
          goal_id?: string;
          id?: string;
          metadata?: Json | null;
          profile_id?: string | null;
          user_id?: string;
        };
        Relationships: [
          {
            foreignKeyName: 'context_embeddings_batch_id_fkey';
            columns: ['batch_id'];
            isOneToOne: false;
            referencedRelation: 'intake_batches';
            referencedColumns: ['id'];
          },
          {
            foreignKeyName: 'context_embeddings_goal_id_fkey';
            columns: ['goal_id'];
            isOneToOne: false;
            referencedRelation: 'goals';
            referencedColumns: ['id'];
          },
          {
            foreignKeyName: 'context_embeddings_profile_id_fkey';
            columns: ['profile_id'];
            isOneToOne: false;
            referencedRelation: 'goal_profiles';
            referencedColumns: ['id'];
          },
        ];
      };
      daily_objectives: {
        Row: {
          created_at: string | null;
          date: string;
          description: string;
          difficulty_rating: string | null;
          goal_id: string;
          id: string;
          is_completed: boolean;
          is_fallback: boolean;
          order_index: number;
          quality_scores: Json | null;
          title: string;
          user_id: string;
          weekly_plan_id: string;
        };
        Insert: {
          created_at?: string | null;
          date: string;
          description: string;
          difficulty_rating?: string | null;
          goal_id: string;
          id?: string;
          is_completed?: boolean;
          is_fallback?: boolean;
          order_index: number;
          quality_scores?: Json | null;
          title: string;
          user_id: string;
          weekly_plan_id: string;
        };
        Update: {
          created_at?: string | null;
          date?: string;
          description?: string;
          difficulty_rating?: string | null;
          goal_id?: string;
          id?: string;
          is_completed?: boolean;
          is_fallback?: boolean;
          order_index?: number;
          quality_scores?: Json | null;
          title?: string;
          user_id?: string;
          weekly_plan_id?: string;
        };
        Relationships: [
          {
            foreignKeyName: 'daily_objectives_goal_id_fkey';
            columns: ['goal_id'];
            isOneToOne: false;
            referencedRelation: 'goals';
            referencedColumns: ['id'];
          },
          {
            foreignKeyName: 'daily_objectives_weekly_plan_id_fkey';
            columns: ['weekly_plan_id'];
            isOneToOne: false;
            referencedRelation: 'weekly_plans';
            referencedColumns: ['id'];
          },
        ];
      };
      debriefs: {
        Row: {
          created_at: string | null;
          date: string;
          goal_id: string;
          id: string;
          note: string;
          task_ratings: Json | null;
          user_id: string;
        };
        Insert: {
          created_at?: string | null;
          date: string;
          goal_id: string;
          id?: string;
          note: string;
          task_ratings?: Json | null;
          user_id: string;
        };
        Update: {
          created_at?: string | null;
          date?: string;
          goal_id?: string;
          id?: string;
          note?: string;
          task_ratings?: Json | null;
          user_id?: string;
        };
        Relationships: [
          {
            foreignKeyName: 'debriefs_goal_id_fkey';
            columns: ['goal_id'];
            isOneToOne: false;
            referencedRelation: 'goals';
            referencedColumns: ['id'];
          },
        ];
      };
      goal_profiles: {
        Row: {
          created_at: string;
          embedded: boolean;
          goal_id: string;
          id: string;
          narrative_summary: string;
          profile_data: Json;
          user_id: string;
        };
        Insert: {
          created_at?: string;
          embedded?: boolean;
          goal_id: string;
          id?: string;
          narrative_summary: string;
          profile_data: Json;
          user_id: string;
        };
        Update: {
          created_at?: string;
          embedded?: boolean;
          goal_id?: string;
          id?: string;
          narrative_summary?: string;
          profile_data?: Json;
          user_id?: string;
        };
        Relationships: [
          {
            foreignKeyName: 'goal_profiles_goal_id_fkey';
            columns: ['goal_id'];
            isOneToOne: true;
            referencedRelation: 'goals';
            referencedColumns: ['id'];
          },
        ];
      };
      goals: {
        Row: {
          created_at: string;
          description: string;
          id: string;
          profile_generation_attempts: number;
          status: string;
          title: string;
          updated_at: string;
          user_id: string;
        };
        Insert: {
          created_at?: string;
          description: string;
          id?: string;
          profile_generation_attempts?: number;
          status?: string;
          title: string;
          updated_at?: string;
          user_id: string;
        };
        Update: {
          created_at?: string;
          description?: string;
          id?: string;
          profile_generation_attempts?: number;
          status?: string;
          title?: string;
          updated_at?: string;
          user_id?: string;
        };
        Relationships: [];
      };
      intake_answers: {
        Row: {
          answer_numeric: number | null;
          answer_text: string | null;
          created_at: string;
          id: string;
          question_id: string;
          selected_options: Json | null;
        };
        Insert: {
          answer_numeric?: number | null;
          answer_text?: string | null;
          created_at?: string;
          id?: string;
          question_id: string;
          selected_options?: Json | null;
        };
        Update: {
          answer_numeric?: number | null;
          answer_text?: string | null;
          created_at?: string;
          id?: string;
          question_id?: string;
          selected_options?: Json | null;
        };
        Relationships: [
          {
            foreignKeyName: 'intake_answers_question_id_fkey';
            columns: ['question_id'];
            isOneToOne: true;
            referencedRelation: 'intake_questions';
            referencedColumns: ['id'];
          },
        ];
      };
      intake_batches: {
        Row: {
          batch_number: number;
          created_at: string;
          embedded: boolean;
          goal_id: string;
          id: string;
          is_answered: boolean;
          is_fallback: boolean;
          quality_score: number | null;
        };
        Insert: {
          batch_number: number;
          created_at?: string;
          embedded?: boolean;
          goal_id: string;
          id?: string;
          is_answered?: boolean;
          is_fallback?: boolean;
          quality_score?: number | null;
        };
        Update: {
          batch_number?: number;
          created_at?: string;
          embedded?: boolean;
          goal_id?: string;
          id?: string;
          is_answered?: boolean;
          is_fallback?: boolean;
          quality_score?: number | null;
        };
        Relationships: [
          {
            foreignKeyName: 'intake_batches_goal_id_fkey';
            columns: ['goal_id'];
            isOneToOne: false;
            referencedRelation: 'goals';
            referencedColumns: ['id'];
          },
        ];
      };
      intake_questions: {
        Row: {
          batch_id: string | null;
          batch_number: number;
          config: Json | null;
          created_at: string;
          goal_id: string;
          id: string;
          order_in_batch: number;
          question_text: string;
          question_type: string;
        };
        Insert: {
          batch_id?: string | null;
          batch_number: number;
          config?: Json | null;
          created_at?: string;
          goal_id: string;
          id?: string;
          order_in_batch: number;
          question_text: string;
          question_type: string;
        };
        Update: {
          batch_id?: string | null;
          batch_number?: number;
          config?: Json | null;
          created_at?: string;
          goal_id?: string;
          id?: string;
          order_in_batch?: number;
          question_text?: string;
          question_type?: string;
        };
        Relationships: [
          {
            foreignKeyName: 'intake_questions_batch_id_fkey';
            columns: ['batch_id'];
            isOneToOne: false;
            referencedRelation: 'intake_batches';
            referencedColumns: ['id'];
          },
          {
            foreignKeyName: 'intake_questions_goal_id_fkey';
            columns: ['goal_id'];
            isOneToOne: false;
            referencedRelation: 'goals';
            referencedColumns: ['id'];
          },
        ];
      };
      milestones: {
        Row: {
          created_at: string | null;
          description: string;
          expected_outcome: string;
          goal_id: string;
          id: string;
          monthly_summary: Json | null;
          order_index: number;
          roadmap_id: string;
          target_month: number;
          title: string;
        };
        Insert: {
          created_at?: string | null;
          description: string;
          expected_outcome: string;
          goal_id: string;
          id?: string;
          monthly_summary?: Json | null;
          order_index: number;
          roadmap_id: string;
          target_month: number;
          title: string;
        };
        Update: {
          created_at?: string | null;
          description?: string;
          expected_outcome?: string;
          goal_id?: string;
          id?: string;
          monthly_summary?: Json | null;
          order_index?: number;
          roadmap_id?: string;
          target_month?: number;
          title?: string;
        };
        Relationships: [
          {
            foreignKeyName: 'milestones_goal_id_fkey';
            columns: ['goal_id'];
            isOneToOne: false;
            referencedRelation: 'goals';
            referencedColumns: ['id'];
          },
          {
            foreignKeyName: 'milestones_roadmap_id_fkey';
            columns: ['roadmap_id'];
            isOneToOne: false;
            referencedRelation: 'roadmaps';
            referencedColumns: ['id'];
          },
        ];
      };
      profiles: {
        Row: {
          coach_id: number | null;
          created_at: string | null;
          date_of_birth: string | null;
          first_name: string | null;
          id: string;
          language: string | null;
          last_name: string | null;
          updated_at: string | null;
        };
        Insert: {
          coach_id?: number | null;
          created_at?: string | null;
          date_of_birth?: string | null;
          first_name?: string | null;
          id: string;
          language?: string | null;
          last_name?: string | null;
          updated_at?: string | null;
        };
        Update: {
          coach_id?: number | null;
          created_at?: string | null;
          date_of_birth?: string | null;
          first_name?: string | null;
          id?: string;
          language?: string | null;
          last_name?: string | null;
          updated_at?: string | null;
        };
        Relationships: [
          {
            foreignKeyName: 'profiles_coach_id_fkey';
            columns: ['coach_id'];
            isOneToOne: false;
            referencedRelation: 'coaches';
            referencedColumns: ['id'];
          },
        ];
      };
      roadmaps: {
        Row: {
          created_at: string | null;
          generation_attempts: number;
          generation_metadata: Json | null;
          goal_id: string;
          id: string;
          model_used: string | null;
          quality_scores: Json | null;
          status: string;
          updated_at: string | null;
          user_id: string;
        };
        Insert: {
          created_at?: string | null;
          generation_attempts?: number;
          generation_metadata?: Json | null;
          goal_id: string;
          id?: string;
          model_used?: string | null;
          quality_scores?: Json | null;
          status?: string;
          updated_at?: string | null;
          user_id: string;
        };
        Update: {
          created_at?: string | null;
          generation_attempts?: number;
          generation_metadata?: Json | null;
          goal_id?: string;
          id?: string;
          model_used?: string | null;
          quality_scores?: Json | null;
          status?: string;
          updated_at?: string | null;
          user_id?: string;
        };
        Relationships: [
          {
            foreignKeyName: 'roadmaps_goal_id_fkey';
            columns: ['goal_id'];
            isOneToOne: true;
            referencedRelation: 'goals';
            referencedColumns: ['id'];
          },
        ];
      };
      user_goals: {
        Row: {
          account_id: string;
          created_at: string | null;
          deadline: string;
          goal_id: string | null;
          id: string;
          initial_goal: string;
          status: Database['public']['Enums']['goal_status'];
          updated_at: string | null;
        };
        Insert: {
          account_id: string;
          created_at?: string | null;
          deadline: string;
          goal_id?: string | null;
          id?: string;
          initial_goal: string;
          status?: Database['public']['Enums']['goal_status'];
          updated_at?: string | null;
        };
        Update: {
          account_id?: string;
          created_at?: string | null;
          deadline?: string;
          goal_id?: string | null;
          id?: string;
          initial_goal?: string;
          status?: Database['public']['Enums']['goal_status'];
          updated_at?: string | null;
        };
        Relationships: [
          {
            foreignKeyName: 'user_goals_account_id_fkey';
            columns: ['account_id'];
            isOneToOne: false;
            referencedRelation: 'profiles';
            referencedColumns: ['id'];
          },
        ];
      };
      weekly_plans: {
        Row: {
          created_at: string | null;
          focus: string;
          generation_context: Json | null;
          generation_metadata: Json | null;
          goal_id: string;
          id: string;
          is_fallback: boolean;
          milestone_id: string;
          model_used: string | null;
          objectives: Json;
          quality_scores: Json | null;
          roadmap_id: string;
          status: string;
          summary: Json | null;
          user_id: string;
          week_number: number;
          week_start_date: string;
        };
        Insert: {
          created_at?: string | null;
          focus: string;
          generation_context?: Json | null;
          generation_metadata?: Json | null;
          goal_id: string;
          id?: string;
          is_fallback?: boolean;
          milestone_id: string;
          model_used?: string | null;
          objectives?: Json;
          quality_scores?: Json | null;
          roadmap_id: string;
          status?: string;
          summary?: Json | null;
          user_id: string;
          week_number: number;
          week_start_date: string;
        };
        Update: {
          created_at?: string | null;
          focus?: string;
          generation_context?: Json | null;
          generation_metadata?: Json | null;
          goal_id?: string;
          id?: string;
          is_fallback?: boolean;
          milestone_id?: string;
          model_used?: string | null;
          objectives?: Json;
          quality_scores?: Json | null;
          roadmap_id?: string;
          status?: string;
          summary?: Json | null;
          user_id?: string;
          week_number?: number;
          week_start_date?: string;
        };
        Relationships: [
          {
            foreignKeyName: 'weekly_plans_goal_id_fkey';
            columns: ['goal_id'];
            isOneToOne: false;
            referencedRelation: 'goals';
            referencedColumns: ['id'];
          },
          {
            foreignKeyName: 'weekly_plans_milestone_id_fkey';
            columns: ['milestone_id'];
            isOneToOne: false;
            referencedRelation: 'milestones';
            referencedColumns: ['id'];
          },
          {
            foreignKeyName: 'weekly_plans_roadmap_id_fkey';
            columns: ['roadmap_id'];
            isOneToOne: false;
            referencedRelation: 'roadmaps';
            referencedColumns: ['id'];
          },
        ];
      };
    };
    Views: {
      [_ in never]: never;
    };
    Functions: {
      match_goal_context: {
        Args: {
          match_count?: number;
          match_threshold?: number;
          p_content_types?: string[];
          p_goal_id: string;
          p_user_id: string;
          query_embedding: string;
        };
        Returns: {
          content_text: string;
          content_type: string;
          id: string;
          metadata: Json;
          similarity: number;
        }[];
      };
    };
    Enums: {
      goal_status: 'initial' | 'generated' | 'ongoing' | 'paused' | 'deleted' | 'completed';
    };
    CompositeTypes: {
      [_ in never]: never;
    };
  };
};

type DatabaseWithoutInternals = Omit<Database, '__InternalSupabase'>;

type DefaultSchema = DatabaseWithoutInternals[Extract<keyof Database, 'public'>];

export type Tables<
  DefaultSchemaTableNameOrOptions extends
    | keyof (DefaultSchema['Tables'] & DefaultSchema['Views'])
    | { schema: keyof DatabaseWithoutInternals },
  TableName extends DefaultSchemaTableNameOrOptions extends {
    schema: keyof DatabaseWithoutInternals;
  }
    ? keyof (DatabaseWithoutInternals[DefaultSchemaTableNameOrOptions['schema']]['Tables'] &
        DatabaseWithoutInternals[DefaultSchemaTableNameOrOptions['schema']]['Views'])
    : never = never,
> = DefaultSchemaTableNameOrOptions extends {
  schema: keyof DatabaseWithoutInternals;
}
  ? (DatabaseWithoutInternals[DefaultSchemaTableNameOrOptions['schema']]['Tables'] &
      DatabaseWithoutInternals[DefaultSchemaTableNameOrOptions['schema']]['Views'])[TableName] extends {
      Row: infer R;
    }
    ? R
    : never
  : DefaultSchemaTableNameOrOptions extends keyof (DefaultSchema['Tables'] & DefaultSchema['Views'])
    ? (DefaultSchema['Tables'] & DefaultSchema['Views'])[DefaultSchemaTableNameOrOptions] extends {
        Row: infer R;
      }
      ? R
      : never
    : never;

export type TablesInsert<
  DefaultSchemaTableNameOrOptions extends
    | keyof DefaultSchema['Tables']
    | { schema: keyof DatabaseWithoutInternals },
  TableName extends DefaultSchemaTableNameOrOptions extends {
    schema: keyof DatabaseWithoutInternals;
  }
    ? keyof DatabaseWithoutInternals[DefaultSchemaTableNameOrOptions['schema']]['Tables']
    : never = never,
> = DefaultSchemaTableNameOrOptions extends {
  schema: keyof DatabaseWithoutInternals;
}
  ? DatabaseWithoutInternals[DefaultSchemaTableNameOrOptions['schema']]['Tables'][TableName] extends {
      Insert: infer I;
    }
    ? I
    : never
  : DefaultSchemaTableNameOrOptions extends keyof DefaultSchema['Tables']
    ? DefaultSchema['Tables'][DefaultSchemaTableNameOrOptions] extends {
        Insert: infer I;
      }
      ? I
      : never
    : never;

export type TablesUpdate<
  DefaultSchemaTableNameOrOptions extends
    | keyof DefaultSchema['Tables']
    | { schema: keyof DatabaseWithoutInternals },
  TableName extends DefaultSchemaTableNameOrOptions extends {
    schema: keyof DatabaseWithoutInternals;
  }
    ? keyof DatabaseWithoutInternals[DefaultSchemaTableNameOrOptions['schema']]['Tables']
    : never = never,
> = DefaultSchemaTableNameOrOptions extends {
  schema: keyof DatabaseWithoutInternals;
}
  ? DatabaseWithoutInternals[DefaultSchemaTableNameOrOptions['schema']]['Tables'][TableName] extends {
      Update: infer U;
    }
    ? U
    : never
  : DefaultSchemaTableNameOrOptions extends keyof DefaultSchema['Tables']
    ? DefaultSchema['Tables'][DefaultSchemaTableNameOrOptions] extends {
        Update: infer U;
      }
      ? U
      : never
    : never;

export type Enums<
  DefaultSchemaEnumNameOrOptions extends
    | keyof DefaultSchema['Enums']
    | { schema: keyof DatabaseWithoutInternals },
  EnumName extends DefaultSchemaEnumNameOrOptions extends {
    schema: keyof DatabaseWithoutInternals;
  }
    ? keyof DatabaseWithoutInternals[DefaultSchemaEnumNameOrOptions['schema']]['Enums']
    : never = never,
> = DefaultSchemaEnumNameOrOptions extends {
  schema: keyof DatabaseWithoutInternals;
}
  ? DatabaseWithoutInternals[DefaultSchemaEnumNameOrOptions['schema']]['Enums'][EnumName]
  : DefaultSchemaEnumNameOrOptions extends keyof DefaultSchema['Enums']
    ? DefaultSchema['Enums'][DefaultSchemaEnumNameOrOptions]
    : never;

export type CompositeTypes<
  PublicCompositeTypeNameOrOptions extends
    | keyof DefaultSchema['CompositeTypes']
    | { schema: keyof DatabaseWithoutInternals },
  CompositeTypeName extends PublicCompositeTypeNameOrOptions extends {
    schema: keyof DatabaseWithoutInternals;
  }
    ? keyof DatabaseWithoutInternals[PublicCompositeTypeNameOrOptions['schema']]['CompositeTypes']
    : never = never,
> = PublicCompositeTypeNameOrOptions extends {
  schema: keyof DatabaseWithoutInternals;
}
  ? DatabaseWithoutInternals[PublicCompositeTypeNameOrOptions['schema']]['CompositeTypes'][CompositeTypeName]
  : PublicCompositeTypeNameOrOptions extends keyof DefaultSchema['CompositeTypes']
    ? DefaultSchema['CompositeTypes'][PublicCompositeTypeNameOrOptions]
    : never;
