export function formatSingleAnswer(answer: Record<string, unknown> | undefined): string {
  if (answer === undefined) {
    return '(no answer)';
  }
  return extractAnswerText(answer);
}

export function extractAnswerText(answer: Record<string, unknown>): string {
  if (typeof answer.answer_text === 'string') {
    return answer.answer_text;
  }
  if (typeof answer.answer_numeric === 'number') {
    return String(answer.answer_numeric);
  }
  if (Array.isArray(answer.selected_options)) {
    return (answer.selected_options as string[]).join(', ');
  }
  return '(no answer)';
}
