// @ts-check
import eslint from '@eslint/js';
import eslintPluginPrettierRecommended from 'eslint-plugin-prettier/recommended';
import globals from 'globals';
import tseslint from 'typescript-eslint';

export default tseslint.config(
  {
    ignores: ['eslint.config.mjs'],
  },
  eslint.configs.recommended,
  ...tseslint.configs.strictTypeChecked,
  eslintPluginPrettierRecommended,
  {
    languageOptions: {
      globals: {
        ...globals.node,
        ...globals.jest,
      },
      sourceType: 'commonjs',
      parserOptions: {
        projectService: true,
        tsconfigRootDir: import.meta.dirname,
      },
    },
  },
  {
    rules: {
      // TypeScript strict rules
      '@typescript-eslint/no-explicit-any': 'error',
      '@typescript-eslint/no-floating-promises': 'error',
      '@typescript-eslint/no-unsafe-argument': 'error',
      '@typescript-eslint/no-unsafe-assignment': 'error',
      '@typescript-eslint/no-unsafe-member-access': 'error',
      '@typescript-eslint/no-unsafe-return': 'error',
      '@typescript-eslint/explicit-function-return-type': [
        'error',
        { allowExpressions: true, allowTypedFunctionExpressions: true },
      ],
      '@typescript-eslint/explicit-member-accessibility': [
        'error',
        { overrides: { constructors: 'no-public' } },
      ],
      '@typescript-eslint/no-non-null-assertion': 'error',
      '@typescript-eslint/consistent-type-imports': [
        'error',
        { prefer: 'type-imports', fixStyle: 'separate-type-imports' },
      ],
      '@typescript-eslint/no-unnecessary-type-assertion': 'error',
      '@typescript-eslint/prefer-readonly': 'error',

      '@typescript-eslint/no-unsafe-call': 'error',
      '@typescript-eslint/no-misused-promises': 'error',
      '@typescript-eslint/restrict-template-expressions': ['error', { allowNumber: true }],
      '@typescript-eslint/promise-function-async': 'error',
      '@typescript-eslint/require-await': 'error',
      '@typescript-eslint/no-shadow': 'error',
      '@typescript-eslint/strict-boolean-expressions': 'error',
      '@typescript-eslint/switch-exhaustiveness-check': 'error',
      '@typescript-eslint/return-await': ['error', 'in-try-catch'],
      '@typescript-eslint/naming-convention': [
        'error',
        { selector: 'default', format: ['camelCase'] },
        { selector: 'variable', format: ['camelCase', 'UPPER_CASE'] },
        { selector: 'parameter', format: ['camelCase'], leadingUnderscore: 'allow' },
        { selector: 'typeLike', format: ['PascalCase'] },
        { selector: 'enumMember', format: ['UPPER_CASE'] },
        {
          selector: 'property',
          format: null,
          filter: { regex: '^(Content-Type|Authorization|x-|_).*', match: true },
        },
        { selector: 'property', format: ['camelCase', 'snake_case', 'UPPER_CASE'] },
        {
          selector: 'variable',
          types: ['boolean'],
          format: ['camelCase'],
          prefix: ['is', 'has', 'should', 'can', 'did', 'will'],
        },
        { selector: 'classMethod', format: ['camelCase'] },
        { selector: 'objectLiteralMethod', format: ['camelCase'] },
        {
          selector: 'import',
          format: ['camelCase', 'PascalCase'],
        },
      ],

      // General strict rules
      'no-console': 'error',
      'no-shadow': 'off', // using @typescript-eslint/no-shadow instead
      'no-param-reassign': 'error',
      'prefer-template': 'error',
      'no-useless-return': 'error',
      'array-callback-return': 'error',
      'no-await-in-loop': 'error',
      'no-promise-executor-return': 'error',
      eqeqeq: 'error',
      complexity: ['error', { max: 10 }],
      'no-magic-numbers': [
        'error',
        { ignore: [-1, 0, 1], ignoreArrayIndexes: true, ignoreDefaultValues: true },
      ],
      'max-lines': ['error', { max: 175, skipComments: true, skipBlankLines: true }],
      'max-lines-per-function': ['error', { max: 35, skipComments: true, skipBlankLines: true }],
      'max-params': ['error', { max: 3 }],
      'max-depth': ['error', { max: 3 }],
      'no-nested-ternary': 'error',
      'no-else-return': 'error',
      'prefer-const': 'error',
      'no-var': 'error',
      curly: 'error',
      'no-restricted-syntax': [
        'error',
        {
          selector: 'CallExpression[callee.property.name="forEach"]',
          message: 'Use for...of instead of .forEach() — supports break, continue, and await.',
        },
      ],

      // Prettier
      'prettier/prettier': ['error', { endOfLine: 'auto' }],
    },
  },
);
